function[dhdx, nonuniform, unsteady, new_geo_p, figure_counter, new_geo, c_p, f_p,...
    c_p_H,f_p_H,w_p_Man,A_p_Man,P_p_Man,R_p_Man,V_p_Man,Q_p_Man,H_p_Man,stage_p,Hi_slope_p,Lo_slope_p,...
    c_r_H,f_r_H,w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r] =...
    get_extra_tau_terms(Q,units,g,c_r,f_r,new_geo,figure_counter,c_r_H,f_r_H,Hi_slope,Lo_slope,...
    w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r)
%[dhdx nonuniform unsteady] = extra_tau_terms
%A function to see what terms the user wants to include.  The term
% dhdx is the change in depth term calculated from c_r and f_r and
% calling the Manning's Function. The nonuniform and unsteady terms are
% also returned using input arguements Q, A_top, g, and the basic facts
% about the time spacing.

term_choice = 0;
tau_choice = 0;

dhdx = zeros(1,length(Q));
nonuniform = zeros(1,length(Q));
unsteady = zeros(1,length(Q));

c_p = 0;
f_p = 0;
c_p_H = 0; f_p_H = 0; w_p_Man = 0; A_p_Man = 0; P_p_Man = 0;
R_p_Man = 0; V_p_Man = 0; Q_p_Man = 0; H_p_Man = 0; stage_p = 0;
Hi_slope_p = 0;
Lo_slope_p = 0;
new_geo_p = 0;

while tau_choice == 0;
    disp(' ')
    disp(' ')
    disp('<<<<    Extra Shear Stress Terms    >>>>')
    disp(' ')
    disp('Besides the gravity term (rho*g*h*S), are there any other terms you would like to include in the shear stress calculation?')
    disp('1. Yes')
    disp('2. No')
    disp(' ')
    tau_choice = input('Please enter 1 or 2: ');
    
    switch tau_choice
        
        case 1  %1st case of tau_choice
            
            A_r = 0;
            A_p = 0;
            dx = 0;
            got_ALL_pool_cf = 0;

            while term_choice == 0
                
                disp(' ')
                disp('What extra terms do you want to include in the shear stress calculation?')
                disp(' ')
                disp('1. The non-uniform change in depth term (dh/dx).')
                disp('2. The non-uniform change in velocity term (U/g*dU/dx).')
                disp('3. The unsteady term (1/g*dU/dt).')
                disp('4. I do not want to include any more terms.')
                disp('*** This menu will prompt again if choice 4 is not entered. *** ')
                disp(' ')
                term_choice = input('Please enter your choice, 1 through 4:  ');
                disp(' ')                
                
                switch term_choice
%% Case 1 - dhdx                    
                    case 1  %1st case of term_choice
                        
                        %only enters this segement if dhdx has not been
                        %calcualted
                        if dhdx == 0    
                            while dx <= 0

                                if units == 1
                                    dx = input('Please enter the distance (in meters) from the pool to the riffle:  ');
                                else
                                    dx = input('Please enter the distance (in feet) from the pool to the riffle:  ');
                                end %if

                                if dx <= 0
                                    disp(' ')
                                    disp('Please enter a positive value.')
                                    disp(' ')
                                end %if

                            end %while
                            
                            if got_ALL_pool_cf == 0
                                [Hi_slope_p, Lo_slope_p, c_p, f_p, new_geo_p, figure_counter, c_p_H, f_p_H,...
                                    w_p_Man, A_p_Man, P_p_Man, R_p_Man, V_p_Man, Q_p_Man, H_p_Man, stage_p] = ...
                                    poolcfchoice(units,figure_counter,term_choice);
                                if c_p && f_p
                                    disp(' ')
                                    fprintf('** The value of c for the pool is %0.4f,',c_p)
                                    fprintf('\n**The value of f for the pool is %0.4f,      where R=cQ^f.',f_p)
                                end
                                disp(' ')
                                disp(' ')
                                fprintf('** The value of c for the pool is %0.4f,',c_p_H)
                                fprintf('\n**The value of f for the pool is %0.4f,      where H=cQ^f.',f_p_H)
                                disp(' ')
                                
                                if c_p && f_p && c_p_H && f_p_H
                                    got_ALL_pool_cf = 1;
                                end
                            end
                            
                            if c_r_H == 0 && f_r_H == 0
                                disp(' ')
                                disp('The values of c and f (where H=cQ^f) for the riffle are needed for this calculation.')
                                disp('Would you like to:')
                                disp('1. Use the values of c and f previously entered (where R=cQ^f).')
                                disp('2. Enter new values for c and f (where H=cQ^f).')
                                disp('3. Enter cross sectional geometry and have this program calculate c and f (where H=cQ^f).')
                                disp(' ')
                                
                                this_choice = 0;
                                while this_choice == 0
                                    this_choice = input('Please enter your choice:  ');

                                    switch this_choice
                                        
                                        case 1
                                            c_r_H = c_r;
                                            f_r_H = f_r;
                                            
                                        case 2
                                            
                                            while c_r_H <= 0 | f_r_H <=0

                                                if units == 1
                                                    disp('** IMPORTANT **')
                                                    disp('Please ensure your calculations of c and f are in Metric units, as you previously incidated.')
                                                else
                                                    disp('** IMPORTANT **')
                                                    disp('Please ensure your calculations of c and f are in English units, as you previously incidated.')
                                                end

                                                disp(' ')
                                                c_r_H = input('Please enter the value of c (where H=cQ^f) for the riffle:  ');
                                                disp(' ')
                                                f_r_H = input('Please enter the value of f (where H=cQ^f) for the riffle:  ');
                                                disp(' ')

                                                if c_r_H <=0 | f_r_H <=0
                                                    disp(' ')
                                                    disp('Please enter positive values for c and f.')
                                                    disp(' ')
                                                end  %if

                                            end %while

                                        case 3
                                            
                                            %Get the xs geo
                                            if units == 1
                                                disp(' ')
                                                disp('Please copy the riffle''s cross-sectional geometry (in meters) into the folder in which this program runs.')
                                                disp(' ')
                                            else
                                                disp(' ')
                                                disp('Please copy the riffle''s cross-sectional geometry (in feet) into the folder in which this program runs.')
                                                disp(' ')
                                            end
                                            xs_string = input('Please input the name of the text file, including the .txt extension:  ','s');
                                            disp(' ')
                                            xs_geo=load(xs_string);

                                            %Get the inc_p
                                            inc = 0;
                                            while inc <= 0

                                                %Check units
                                                if units == 1
                                                    inc = input('Please enter the power regression stage increment (in meters) for the Manning''s calcualtion:  ');
                                                else
                                                    inc = input('Please enter the power regression stage increment (in feet) for the Manning''s calculation:  ');
                                                end

                                                if inc <= 0
                                                    disp(' ')
                                                    disp('Please input a positive value.')
                                                end % if
                                            end % while

                                            %Get the mannings n
                                            n = 0;
                                            while n <= 0

                                                disp(' ')
                                                n = input('Please input the value of the Mannings n:  ');

                                                if n <= 0
                                                    disp(' ')
                                                    disp('Please input a positive value.')
                                                end % if

                                            end % while

                                            %Call the simpler mannings function
                                            [dontuse1,dontuse2,new_geo,figure_counter,c_r_H,f_r_H,...
                                                w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r] = ...
                                                Mannings(xs_geo,n,Hi_slope,Lo_slope,inc,figure_counter,units);
                                        otherwise
                                            disp(' ')
                                            disp('Please enter either 1, 2, or 3.')
                                            disp(' ')
                                            this_choice = 0;
                                    end %of switch

                                end %of while

                            end %of if

                            disp(' ')
                            disp('*** The program is calculating the change in depth term ***')
                            disp(' ')

                            for i=1:length(Q)
                                dhdx(i) = (c_r_H*Q(i)^f_r_H - c_p_H*Q(i)^f_p_H)/dx;
                            end

                            disp(' ')
                            disp('*** The change in depth term has been calculated. ***')
                            disp(' ')
                        else
                            disp(' ')
                            disp('The change in depth term has already been calculated.')
                            disp(' ')
                        end %large if statement
                        term_choice = 0;
                        
%% Case 2 - nonuniform                   
                    case 2  %2nd case of term_choice
                        
                        %only enters this statement if nonuniform is zero
                        if nonuniform == 0
                            
                            while dx <= 0

                                if units == 1
                                    dx = input('Please enter the distance (in meters) from the pool to the riffle:  ');
                                    disp(' ')
                                else
                                    dx = input('Please enter the distance (in feet) from the pool to the riffle:  ');
                                    disp(' ')
                                end %if

                                if dx <= 0                                    
                                    disp('Please enter a positive value.')
                                    disp(' ')
                                end %if

                            end %while

                            if got_ALL_pool_cf == 0
                                [Hi_slope_p, Lo_slope_p, c_p, f_p, new_geo_p, figure_counter, c_p_H, f_p_H,...
                                    w_p_Man, A_p_Man, P_p_Man, R_p_Man, V_p_Man, Q_p_Man, H_p_Man, stage_p] = ...
                                    poolcfchoice(units,figure_counter,term_choice);
                                
                                disp(' ')
                                fprintf('** The value of c for the pool is %0.4f,',c_p)
                                fprintf('\n**The value of f for the pool is %0.4f,      where R=cQ^f.',f_p)
                                disp(' ')
                                if c_p_H && f_p_H
                                    disp(' ')
                                    fprintf('** The value of c for the pool is %0.4f,',c_p_H)
                                    fprintf('\n**The value of f for the pool is %0.4f,      where H=cQ^f.',f_p_H)
                                end
                                disp(' ')
                                
                                if c_p && f_p && c_p_H && f_p_H
                                    got_ALL_pool_cf = 1;
                                end
                               
                            end

                            if new_geo == 0

                                if units == 1
                                    disp('Please copy the riffle''s cross-sectional geometry (in meters) into the folder in which this program runs.')
                                    disp(' ')
                                else
                                    disp('Please copy the riffle''s cross-sectional geometry (in feet) into the folder in which this program runs.')
                                    disp(' ')
                                end
                                xs_string = input('Please input the name of the text file, including the .txt extension:  ','s');
                                disp(' ')
                                xs_geo=load(xs_string);

                                %Set xs_geo to reference coordinates
                                minimums = min(xs_geo);
                                xmin = minimums(1,1);
                                ymin = minimums(1,2);

                                for i=1:length(xs_geo)
                                    new_geo(i,1) = xs_geo(i,1)-xmin;
                                    new_geo(i,2) = xs_geo(i,2)-ymin;
                                end

                            end %if

                            if new_geo_p == 0

                                if units == 1                                    
                                    disp('Please copy the pool''s cross-sectional geometry (in meters) into the folder in which this program runs.')
                                    disp(' ')
                                else                                  
                                    disp('Please copy the pool''s cross-sectional geometry (in feet) into the folder in which this program runs.')
                                    disp(' ')
                                end

                                xs_string_p = input('Please input the name of the text file, including the .txt extension:  ','s');
                                disp(' ')
                                xs_geo_p=load(xs_string_p);

                                %Set xs_geo to reference coordinates
                                minimums = min(xs_geo_p);
                                xmin = minimums(1,1);
                                ymin = minimums(1,2);

                                for i=1:length(xs_geo_p)
                                    new_geo_p(i,1) = xs_geo_p(i,1)-xmin;
                                    new_geo_p(i,2) = xs_geo_p(i,2)-ymin;
                                end

                            end %if

                            disp(' ')
                            disp('*** The program is calculating the change in velocity term ***')
                            disp(' ')

                            if A_p == 0

                                for i=1:length(Q)
                                    A_p(i) = get_area(Q(i), c_p, f_p, new_geo_p);
                                end

                            end

                            if A_r == 0
                                
                                for i=1:length(Q)
                                    A_r(i) = get_area(Q(i), c_r, f_r, new_geo);                                    
                                end
                                
                            end

                            for i=1:length(Q)
                                nonuniform(i) = Q(i)^2*(A_r(i)^-1 - A_p(i)^-1)/(g*A_r(i)*dx);
                            end
                            
                            disp(' ')
                            disp('*** The change in velocity term has been calculated ***');
                            disp(' ')
                            
                        else

                            disp(' ')
                            disp('The change in velocity term has already been calculated.')
                            disp(' ')

                        end %large if statement
                        term_choice = 0;
%% Case 3                        
                    case 3  %3rd case of term_choice
                        
                        %only enters this statement if unsteady is zero
                        if unsteady == 0

                            if new_geo == 0

                                if units == 1
                                    disp('Please copy the riffle''s cross-sectional geometry (in meters) into the folder in which this program runs.')
                                    disp(' ')
                                else
                                    disp('Please copy the riffle''s cross-sectional geometry (in feet) into the folder in which this program runs.')
                                    disp(' ')
                                end

                                xs_string = input('Please input the name of the text file, including the .txt extension:  ','s');
                                disp(' ')
                                xs_geo = load(xs_string);

                                %Set xs_geo to reference coordinates
                                minimums = min(xs_geo);
                                xmin = minimums(1,1);
                                ymin = minimums(1,2);

                                for i=1:length(xs_geo)
                                    new_geo(i,1) = xs_geo(i,1) - xmin;
                                    new_geo(i,2) = xs_geo(i,2) - ymin;
                                end

                            end %if

                            disp(' ')
                            disp('*** The program is calculating the unsteady term ***')
                            disp(' ')

                            if A_r == 0
                                for i=1:length(Q)
                                    A_r(i) = get_area(Q(i), c_r, f_r, new_geo);
                                end                                
                            end

                            dt = 86400; %86400 seconds in one day
                            
                            %special case of the first day
                            i = 1;
                            unsteady(i) = Q(i)*(A_r(i+1)^-1 - A_r(i)^-1)/(g*dt);

                            for i=2:length(Q)
                                unsteady(i) = Q(i)*(A_r(i)^-1 - A_r(i-1)^-1)/(g*dt);
                            end
                            
                            disp(' ')
                            disp('*** The unsteady term has been calculated ***');
                            disp(' ')

                        else

                            disp(' ')
                            disp('The unsteady term has already been calculated.')
                            disp(' ')

                        end %large if statement
                        term_choice = 0;
%% Case 4                        
                    case 4  %4th case of term_choice
                        
                        return
                        
                    otherwise
                        disp(' ')
                        disp('Please enter a number, 1 through 4.')
                        term_choice = 0;
                        
                end % term switch
            end % term while
            
        case 2  %2nd case of the tau_choice
            
            new_geo_p = 0;
            return
            
        otherwise % otherwise of tau_choice
            disp(' ')
            disp('Please enter either 1 or 2.')
            disp(' ')
            tau_choice = 0;
            
    end % tau switch
end % tau while